
******************************************************************************
****       Beispiel einer Scheinkorrelation
****          Macht Homöopathie gesund?
****        Stefanie Heyne / Josef Brüderl
****                Oktober 2018
******************************************************************************

* Kumulierter Allbus 1980-2016
use "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\Allbus 1980_2016\ZA4586_v1-0-0.dta", clear 

tab rh13a year, nol

keep if year==2012      // nur Allbus 2012

* Gesundheitszustand
tab hs01, nol
recode hs01 -9=. 5=1 4=2 3=3 2=4 1=5, into(gesund)
label variable gesund "Gesundheitszustand Befragter"
label define gesundlbl 1 "schlecht" 2 "weniger gut" 3 "zufriedenstellend" 4 "gut" 5 "sehr gut"
label value gesund gesundlbl
tab gesund, m

* Homöopathie
tab rh13a
recode rh13a  -6 2 =0  1=1  -9=., into(homoe)
label variable homoe "Erfahrung mit Homöopathie"
label define homoelbl 0 "Keine Homöopathieerfahrung" 1 "Homöopathieerfahrung" 
label value homoe homoelbl
tab homoe, m

* Bildung
tab educ
recode educ 1 2 = 1  3 = 2  4 5 = 3   -9 -1 6 7 = ., into(bild)
label variable bild "Schulbildung"
label define bildlbl 1 "Hauptschule" 2 "Realschule" 3 "Abitur"
label value bild bildlbl
tab bild, m

* Alter
recode age -32=.

* Kreuztabellen
tab gesund homoe, col chi2
tab homoe bild, col chi2
corr homoe age

* Eine Kreuztabelle dargestellt in einem gruppierten Boxplot
* net install catplot.pkg

tab gesund homoe, col chi2

catplot homoe gesund, recast(bar) percent(homoe) asyvar ///
        bargap(10) bar(1,color(red)) bar(2,color(blue)) ///
        ylabel(0(5)45, grid angle(0)) ytitle("Prozent") ///
		title("Gesundheitszustand Befragter nach Homöopathieerfahrung") 

* Erfahrung mit Homöopathie nach Alter
twoway (lowess homoe age if bild==1 & age<80, lwidth(medthick))  ///
       (lowess homoe age if bild==2 & age<80, lwidth(medthick))  ///
	   (lowess homoe age if bild==3 & age<80, lwidth(medthick)), ///
     ylabel(0(.1).7, grid angle(0)) ytitle("Anteil mit Homöopathieerfahrung")   ///
	 xlabel(20(10)80) xtitle("Alter Befragter")   ///
	 legend(label(1 "Hauptschule") label(2 "Realschule") label(3 "Abitur") row(1)) ///
	 title("Erfahrung mit Homöopathie nach Alter (Lowess)")

	 
* Regressionen
drop if missing(gesund,homoe,bild,age)
regr gesund homoe
est store  m1
regr gesund homoe i.bild
est store  m2
regr gesund homoe i.bild age
est store  m3

esttab m1 m2 m3, b(%6.3f) star se r2
